package game;

import java.awt.Graphics;
import java.util.ArrayList;


public class CustomNpc extends CollidableObject{
	
	private CustomNpcBehavior currentBehavior;
	private int xPos;
	private int yPos;
	
	private int nextXPos;
	private int nextYPos;
	
	private int width;
	private int height;
	
	public CustomNpc(CustomNpcBehavior initialBehavior, int initXPos, int initYPos, int desiredWidth, int desiredHeight) {
		
		currentBehavior = initialBehavior;
		
		xPos = initXPos;
		yPos = initYPos;
		
		width = desiredWidth;
		height = desiredHeight;
		
	}
	
	public void update(PlayerSprite player, StaticBlockManager blockManager, ArrayList<SolidBlockSprite> blocks) {
		
		if(currentBehavior != null)
			currentBehavior = currentBehavior.update(this, player, blockManager, blocks);
		
	}
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		if(currentBehavior == null)
			return;
		
//		System.out.println("<><>DELME about to draw an enemy facing " + Character.toString(facing) + ", at " + (panelWidth/2 + (xPos - player.getxPos())) + ", " + (panelHeight/2 + (yPos - player.getyPos())));
		
		int xDraw = panelWidth/2 + (xPos - player.getxPos());
		int yDraw = panelHeight/2 + (yPos - player.getyPos());
		
		
		currentBehavior.draw(g, xDraw, yDraw);
		
	}

	public int getxPos() {
		return xPos;
	}

	public int getyPos() {
		return yPos;
	}

	public void setxPos(int xPos) {
		this.xPos = xPos;
	}

	public void setyPos(int yPos) {
		this.yPos = yPos;
	}
	
	
	
	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public boolean shouldDrawOverPlayer() {
		if(currentBehavior == null) {
			return false;
		} else {
			return currentBehavior.shouldDrawOverPlayer();
		}
	}
	
	
	public IntRect getCollisionRect() {
		return new IntRect(xPos - width/2, yPos - height/2, width, height);
	}

	@Override
	public IntRect getNextPosCollisionRect() {
		
		IntRect returnValue = new IntRect(nextXPos - width/2, nextYPos - height/2, width, height);
		
		return returnValue;
	}

	@Override
	public int getNextXPos() {
		return nextXPos;
	}

	@Override
	public int getCollisionWidth() {
		return width;
	}

	@Override
	public IntRect getCurrentPosCollisionRect() {
		IntRect returnValue = new IntRect(xPos - width/2, yPos - height/2, width, height);
		
		return returnValue;
	}

	@Override
	public int getNextYPos() {
		return nextYPos;
	}

	@Override
	public int getCollisionHeight() {
		return height;
	}

	public void setNextXPos(int nextXPos) {
		this.nextXPos = nextXPos;
	}

	public void setNextYPos(int nextYPos) {
		this.nextYPos = nextYPos;
	}
	
	
}
